// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_WILL_OVERFLOW_ON_ADD_HPP
#define ED_WILL_OVERFLOW_ON_ADD_HPP

#include "FundamentalIntConcepts.hpp"
#include "Limits.hpp"

namespace ed
{
   template <FUNDAMENTAL_UINT T>
      constexpr bool willOverflowOnAdd(const T& a, const T& b) noexcept
      { return (maxOf_V<T> - a) < b; }
}

#endif // ED_WILL_OVERFLOW_ON_ADD_HPP
