// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "subsampledContainerSize.hpp"

#include "_checkInterface_subsampledContainerSize.hpp"

namespace ed
{
   uintmax_t subsampledContainerSize(const uintmax_t& containerSize, const uintmax_t& subsamplingFactor) noexcept(!config::debuggingEnabledFor_subsampledContainerSize)
   {
      if constexpr (config::debuggingEnabledFor_subsampledContainerSize)
         _checkInterface_subsampledContainerSize(containerSize, subsamplingFactor);

      return containerSize ? ((containerSize - 1) / subsamplingFactor + 1)
                           : 0;
   }
}
