// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_SUBSAMPLE_VIEW_S_HPP
#define ED_SUBSAMPLE_VIEW_S_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorScale.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "_subsampleView.hpp"

#include <cstdint>

namespace ed
{
   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(I_ContainerSolid<StoredType>& container) noexcept
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(const I_ContainerSolid<StoredType>& container) noexcept
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(I_ContainerAbstract<StoredType>& container) noexcept
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(const I_ContainerAbstract<StoredType>& container) noexcept
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(IM_ContainerSolidFinite<StoredType>& container)
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(const IM_ContainerSolidFinite<StoredType>& container)
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(IM_ContainerAbstractFinite<StoredType>& container)
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorScale_S<SubsamplingFactor>, ViewPropertiesAlwaysMutable_If_m>
            subsampleView_S(const IM_ContainerAbstractFinite<StoredType>& container)
            { return _subsampleView_S<SubsamplingFactor, ViewPropertiesAlwaysMutable_If_m>(container); }
}

#endif // ED_SUBSAMPLE_VIEW_S_HPP
