// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_SUBSAMPLE_VIEW_HPP
#define ED_SUBSAMPLE_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorScale.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_subsampleView.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(I_ContainerSolid<StoredType>& container, const uintmax_t& subsamplingFactor) noexcept(!config::debuggingEnabledFor_subsampleView)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(const I_ContainerSolid<StoredType>& container, const uintmax_t& subsamplingFactor) noexcept(!config::debuggingEnabledFor_subsampleView)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(I_ContainerAbstract<StoredType>& container, const uintmax_t& subsamplingFactor) noexcept(!config::debuggingEnabledFor_subsampleView)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(const I_ContainerAbstract<StoredType>& container, const uintmax_t& subsamplingFactor) noexcept(!config::debuggingEnabledFor_subsampleView)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& subsamplingFactor)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(const IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& subsamplingFactor)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& subsamplingFactor)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorScale, ViewPropertiesAlwaysMutable_If_m>
            subsampleView(const IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& subsamplingFactor)
            { return _subsampleView<ViewPropertiesAlwaysMutable_If_m>(container, subsamplingFactor); }
}

#include "subsampleView_S.hpp"

#endif // ED_SUBSAMPLE_VIEW_HPP
