// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_REVERSE_VIEW_HPP
#define ED_REVERSE_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorReverse.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "_reverseView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorReverse, ViewPropertiesAlwaysMutable_If_m>
            reverseView(IM_ContainerSolidFinite<StoredType>& container)
            { return _reverseView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorReverse, ViewPropertiesAlwaysMutable_If_m>
            reverseView(const IM_ContainerSolidFinite<StoredType>& container)
            { return _reverseView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorReverse, ViewPropertiesAlwaysMutable_If_m>
            reverseView(IM_ContainerAbstractFinite<StoredType>& container)
            { return _reverseView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorReverse, ViewPropertiesAlwaysMutable_If_m>
            reverseView(const IM_ContainerAbstractFinite<StoredType>& container)
            { return _reverseView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorReverse_S<ContainerSize - 1>, ViewPropertiesAlwaysMutable_If_m>
            reverseView_S(IM_ContainerSolidFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_reverseView_S)
            { return _reverseView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'f', FunctorReverse_S<ContainerSize - 1>, ViewPropertiesAlwaysMutable_If_m>
            reverseView_S(const IM_ContainerSolidFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_reverseView_S)
            { return _reverseView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorReverse_S<ContainerSize - 1>, ViewPropertiesAlwaysMutable_If_m>
            reverseView_S(IM_ContainerAbstractFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_reverseView_S)
            { return _reverseView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'f', FunctorReverse_S<ContainerSize - 1>, ViewPropertiesAlwaysMutable_If_m>
            reverseView_S(const IM_ContainerAbstractFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_reverseView_S)
            { return _reverseView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }
}

#endif // ED_REVERSE_VIEW_HPP
