// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_PART_VIEW_S_HPP
#define ED_PART_VIEW_S_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorOffset.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_partView.hpp"

#include <cstdint>

namespace ed
{
   /// 2-argument (3 if including FirstIndex template parameter) variants creating view of solid container

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(I_ContainerSolid<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const I_ContainerSolid<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

   /// 2-argument (3 if including FirstIndex template parameter) variants creating view of abstract container

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(I_ContainerAbstract<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const I_ContainerAbstract<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex); }

   /// 1-argument (2 if including FirstIndex template parameter) variants creating view of solid container

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(I_ContainerSolid<StoredType>& container) noexcept
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const I_ContainerSolid<StoredType>& container) noexcept
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(IM_ContainerSolidFinite<StoredType>& container)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const IM_ContainerSolidFinite<StoredType>& container)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

   /// 1-argument (2 if including FirstIndex template parameter) variants creating view of abstract container

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(I_ContainerAbstract<StoredType>& container) noexcept
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const I_ContainerAbstract<StoredType>& container) noexcept
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(IM_ContainerAbstractFinite<StoredType>& container)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }

      template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partView_S(const IM_ContainerAbstractFinite<StoredType>& container)
               { return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container); }
}

#endif // ED_PART_VIEW_S_HPP
