// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_PART_VIEW_N_S_HPP
#define ED_PART_VIEW_N_S_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorOffset.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_partViewN.hpp"

#include <cstdint>

namespace ed
{
   /// Variants creating view of solid container

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(I_ContainerSolid<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(const I_ContainerSolid<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(const IM_ContainerSolidFinite<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

   /// Variants creating view of abstract container

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(I_ContainerAbstract<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(const I_ContainerAbstract<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }

      template <uintmax_t FirstIndex = 0, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset_S<FirstIndex>, ViewPropertiesAlwaysMutable_If_m>
               partViewN_S(const IM_ContainerAbstractFinite<StoredType>& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
               { return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, elemCount); }
}

#endif // ED_PART_VIEW_N_S_HPP
