// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_PART_VIEW_N_HPP
#define ED_PART_VIEW_N_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorOffset.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_partViewN.hpp"

#include <cstdint>

namespace ed
{
   /// Variants creating view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(      I_ContainerSolid<StoredType>& container,
                         const uintmax_t&                    elemCount,
                         const uintmax_t&                    firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(const I_ContainerSolid<StoredType>& container,
                         const uintmax_t&                    elemCount,
                         const uintmax_t&                    firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(      IM_ContainerSolidFinite<StoredType>& container,
                         const uintmax_t&                     elemCount,
                         const uintmax_t&                     firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(const IM_ContainerSolidFinite<StoredType>& container,
                         const uintmax_t&                           elemCount,
                         const uintmax_t&                           firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

   /// Variants creating view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(      I_ContainerAbstract<StoredType>& container,
                         const uintmax_t&                       elemCount,
                         const uintmax_t&                       firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(const I_ContainerAbstract<StoredType>& container,
                         const uintmax_t&                       elemCount,
                         const uintmax_t&                       firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(      IM_ContainerAbstractFinite<StoredType>& container,
                         const uintmax_t&                              elemCount,
                         const uintmax_t&                              firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partViewN(const IM_ContainerAbstractFinite<StoredType>& container,
                         const uintmax_t&                              elemCount,
                         const uintmax_t&                              firstIndex = 0) noexcept(!config::debuggingEnabledFor_partViewN)
               { return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, elemCount, firstIndex); }
}

#endif // ED_PART_VIEW_N_HPP
