// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_PART_VIEW_HPP
#define ED_PART_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorOffset.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_partView.hpp"

#include <cstdint>

namespace ed
{
   /// 3-argument variants creating view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      I_ContainerSolid<StoredType>& container,
                        const uintmax_t&                    firstIndex,
                        const uintmax_t&                    lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const I_ContainerSolid<StoredType>& container,
                        const uintmax_t&                    firstIndex,
                        const uintmax_t&                    lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      IM_ContainerSolidFinite<StoredType>& container,
                        const uintmax_t&                           firstIndex,
                        const uintmax_t&                           lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const IM_ContainerSolidFinite<StoredType>& container,
                        const uintmax_t&                           firstIndex,
                        const uintmax_t&                           lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

   /// 3-argument variants creating view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      I_ContainerAbstract<StoredType>& container,
                        const uintmax_t&                       firstIndex,
                        const uintmax_t&                       lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const I_ContainerAbstract<StoredType>& container,
                        const uintmax_t&                       firstIndex,
                        const uintmax_t&                       lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      IM_ContainerAbstractFinite<StoredType>& container,
                        const uintmax_t&                              firstIndex,
                        const uintmax_t&                              lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const IM_ContainerAbstractFinite<StoredType>& container,
                        const uintmax_t&                              firstIndex,
                        const uintmax_t&                              lastIndex)  noexcept(!config::debuggingEnabledFor_partView)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex); }

   /// 2-argument variants creating view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'i', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      I_ContainerSolid<StoredType>& container,
                        const uintmax_t&                    firstIndex) noexcept
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'i', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const I_ContainerSolid<StoredType>& container,
                        const uintmax_t&                    firstIndex) noexcept
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      IM_ContainerSolidFinite<StoredType>& container,
                        const uintmax_t&                           firstIndex)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const IM_ContainerSolidFinite<StoredType>& container,
                        const uintmax_t&                           firstIndex)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

   /// 2-argument variants creating view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'i', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      I_ContainerAbstract<StoredType>& container,
                        const uintmax_t&                       firstIndex) noexcept
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'i', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const I_ContainerAbstract<StoredType>& container,
                        const uintmax_t&                       firstIndex) noexcept
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(      IM_ContainerAbstractFinite<StoredType>& container,
                        const uintmax_t&                              firstIndex)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', FunctorOffset, ViewPropertiesAlwaysMutable_If_m>
               partView(const IM_ContainerAbstractFinite<StoredType>& container,
                        const uintmax_t&                              firstIndex)
               { return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex); }
}

#include "partView_S.hpp"
#include "partViewN.hpp"
#include "partViewN_S.hpp"

#endif // ED_PART_VIEW_HPP
