// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_META_FUNCTOR_HPP
#define ED_META_FUNCTOR_HPP

#include "I_FunctorBase_ConstCallOp.hpp"
#include "I_FunctorBase_MutatingCallOp.hpp"

#include <type_traits>

namespace ed
{
   namespace meta_Functor
   {
      namespace flags
      {
         namespace ConstOrMutatingCallOp
         {
            template <char Flag> static constexpr bool isCorrect_V = (Flag == 'c') || (Flag == 'm');
            template <char Flag> struct MustBeCorrect { static_assert(isCorrect_V<Flag>, "`ConstOrMutatingCallOp` template argument must be either 'c' or 'm'."); };
         }
      }

      namespace hasTrait
      {
         template <char ConstOrMutatingCallOp> requires(flags::ConstOrMutatingCallOp::MustBeCorrect<ConstOrMutatingCallOp>{}, true)
            static constexpr bool hasConstCallOp_V = (ConstOrMutatingCallOp == 'c');

         template <char ConstOrMutatingCallOp> requires(flags::ConstOrMutatingCallOp::MustBeCorrect<ConstOrMutatingCallOp>{}, true)
            static constexpr bool hasMutatingCallOp_V = !hasConstCallOp_V<ConstOrMutatingCallOp>;
      }

      template <char ConstOrMutatingCallOp, typename ReturnType, typename... ArgumentTypes> requires(flags::ConstOrMutatingCallOp::MustBeCorrect<ConstOrMutatingCallOp>{}, true)
         using BaseInterface_T = std::conditional_t<hasTrait::hasConstCallOp_V<ConstOrMutatingCallOp>,
                                                                               I_FunctorBase_ConstCallOp   <ReturnType, ArgumentTypes...>,
                                                                               I_FunctorBase_MutatingCallOp<ReturnType, ArgumentTypes...>>;
   }
}

#endif // ED_META_FUNCTOR_HPP
