// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_META_CONTAINER_VIEW_BASE_TYPES_HPP
#define ED_META_CONTAINER_VIEW_BASE_TYPES_HPP

#include "meta_ContainerView_base.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "I_Functor.hpp"

#include <type_traits>
#include <cstdint>

namespace ed
{
   namespace meta_ContainerView
   {
      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite> requires(flags::SolidOrAbstract ::MustBeCorrect<SolidOrAbstract> {},
                                                                                           flags::FiniteOrInfinite::MustBeCorrect<FiniteOrInfinite>{}, true)
         using BaseContainerInterface_T = std::conditional_t<hasTrait::isFinite_V<FiniteOrInfinite>,
                                                             std::conditional_t<hasTrait::isSolid_V       <SolidOrAbstract>,
                                                                                IM_ContainerSolidFinite   <StoredType>,
                                                                                IM_ContainerAbstractFinite<StoredType>>,
                                                             std::conditional_t<hasTrait::isSolid_V<SolidOrAbstract>,
                                                                                I_ContainerSolid   <StoredType>,
                                                                                I_ContainerAbstract<StoredType>>>;

      template <typename StoredType, char SolidOrAbstract> requires(flags::SolidOrAbstract::MustBeCorrect<SolidOrAbstract>{}, true)
         using TargetInterface_T = std::conditional_t<hasTrait::isSolid_V<SolidOrAbstract>,
                                                      I_ContainerSolid   <StoredType>,
                                                      I_ContainerAbstract<StoredType>>;

      template <char ConstOrMutatingFunctorCallOp> requires(flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>{}, true)
         using MappingFunctorInterface_T = std::conditional_t<hasTrait::usesFunctorWithConstCallOp_V<ConstOrMutatingFunctorCallOp>,
                                                              const I_Functor<'c', uintmax_t, const uintmax_t&>,
                                                                    I_Functor<'m', uintmax_t, const uintmax_t&>>;
   }
}

#endif // ED_META_CONTAINER_VIEW_BASE_TYPES_HPP
