// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_META_CONTAINER_VIEW_BASE_HPP
#define ED_META_CONTAINER_VIEW_BASE_HPP

#include "meta_Functor.hpp"

namespace ed
{
   namespace meta_ContainerView
   {
      namespace flags
      {
         namespace SolidOrAbstract
         {
            template <char Flag> static constexpr bool isCorrect_V = (Flag == 's') || (Flag == 'a');
            template <char Flag> struct MustBeCorrect { static_assert(isCorrect_V<Flag>, "`SolidOrAbstract` template argument must be either 's' or 'a'."); };
         }

         namespace FiniteOrInfinite
         {
            template <char Flag> static constexpr bool isCorrect_V = (Flag == 'f') || (Flag == 'i');
            template <char Flag> struct MustBeCorrect { static_assert(isCorrect_V<Flag>, "`FiniteOrInfinite` template argument must be either 'f' or 'i'."); };
         }

         namespace ConstOrMutatingFunctorCallOp
         {
            template <char Flag> static constexpr bool isCorrect_V = meta_Functor::flags::ConstOrMutatingCallOp::isCorrect_V<Flag>;
            template <char Flag> struct MustBeCorrect { static_assert(isCorrect_V<Flag>, "`ConstOrMutatingFunctorCallOp` template argument must be either 'c' or 'm'."); };
         }

         namespace ViewPropertiesAlwaysMutable
         {
            template <char Flag> static constexpr bool isCorrect_V = (Flag == ' ') || (Flag == 'm');
            template <char Flag> struct MustBeCorrect { static_assert(isCorrect_V<Flag>, "`ViewPropertiesAlwaysMutable_If_m` template argument must be either ' ' or 'm'."); };
         }
      }

      namespace hasTrait
      {
         template <char SolidOrAbstract> requires(flags::SolidOrAbstract::MustBeCorrect<SolidOrAbstract>{}, true)
            static constexpr bool isSolid_V = (SolidOrAbstract == 's');

         template <char SolidOrAbstract> requires(flags::SolidOrAbstract::MustBeCorrect<SolidOrAbstract>{}, true)
            static constexpr bool isAbstract_V = !isSolid_V<SolidOrAbstract>;

         template <char FiniteOrInfinite> requires(flags::FiniteOrInfinite::MustBeCorrect<FiniteOrInfinite>{}, true)
            static constexpr bool isFinite_V = (FiniteOrInfinite == 'f');

         template <char FiniteOrInfinite> requires(flags::FiniteOrInfinite::MustBeCorrect<FiniteOrInfinite>{}, true)
            static constexpr bool isInfinite_V = !isFinite_V<FiniteOrInfinite>;

         template <char ConstOrMutatingFunctorCallOp> requires(flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>{}, true)
            static constexpr bool usesFunctorWithConstCallOp_V = (ConstOrMutatingFunctorCallOp == 'c');

         template <char ConstOrMutatingFunctorCallOp> requires(flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>{}, true)
            static constexpr bool usesFunctorWithMutatingCallOp_V = !usesFunctorWithConstCallOp_V<ConstOrMutatingFunctorCallOp>;

         template <char ViewPropertiesAlwaysMutable_If_m> requires(flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            static constexpr bool hasAlwaysMutableProperties_V = (ViewPropertiesAlwaysMutable_If_m == 'm');
      }
   }
}

#include "meta_ContainerView_base_types.hpp"

#endif // ED_META_CONTAINER_VIEW_BASE_HPP
