// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_META_CONTAINER_VIEW_HPP
#define ED_META_CONTAINER_VIEW_HPP

#include "meta_ContainerView_base.hpp"
#include "I_ContainerViewBase.hpp"
#include "I_ContainerViewFinite.hpp"
#include "I_ContainerViewAMP.hpp"
#include "I_ContainerViewFiniteAMP.hpp"

namespace ed
{
   namespace meta_ContainerView
   {
      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>                 {},
                  meta_ContainerView::flags::FiniteOrInfinite            ::MustBeCorrect<FiniteOrInfinite>                {},
                  meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>    {},
                  meta_ContainerView::flags::ViewPropertiesAlwaysMutable ::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         using BaseViewInterface_T
             = std::conditional_t<hasTrait::isFinite_V<FiniteOrInfinite>,
                                  std::conditional_t<
                                     hasTrait::hasAlwaysMutableProperties_V<ViewPropertiesAlwaysMutable_If_m>,
                                     I_ContainerViewFiniteAMP              <StoredType, SolidOrAbstract, ConstOrMutatingFunctorCallOp>,
                                     I_ContainerViewFinite                 <StoredType, SolidOrAbstract, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>>,
                                  std::conditional_t<
                                     hasTrait::hasAlwaysMutableProperties_V<ViewPropertiesAlwaysMutable_If_m>,
                                     I_ContainerViewAMP                    <StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp>,
                                     I_ContainerViewBase                   <StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>>>;
   }
}

#endif // ED_META_CONTAINER_VIEW_HPP
