// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_LOOPED_VIEW_HPP
#define ED_LOOPED_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "FunctorWrap.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "_loopedView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorWrap, ViewPropertiesAlwaysMutable_If_m>
            loopedView(IM_ContainerSolidFinite<StoredType>& container)
            { return _loopedView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorWrap, ViewPropertiesAlwaysMutable_If_m>
            loopedView(const IM_ContainerSolidFinite<StoredType>& container)
            { return _loopedView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorWrap, ViewPropertiesAlwaysMutable_If_m>
            loopedView(IM_ContainerAbstractFinite<StoredType>& container)
            { return _loopedView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorWrap, ViewPropertiesAlwaysMutable_If_m>
            loopedView(const IM_ContainerAbstractFinite<StoredType>& container)
            { return _loopedView<ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorWrap_S<ContainerSize>, ViewPropertiesAlwaysMutable_If_m>
            loopedView_S(IM_ContainerSolidFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_loopedView_S)
            { return _loopedView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 's', 'i', FunctorWrap_S<ContainerSize>, ViewPropertiesAlwaysMutable_If_m>
            loopedView_S(const IM_ContainerSolidFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_loopedView_S)
            { return _loopedView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorWrap_S<ContainerSize>, ViewPropertiesAlwaysMutable_If_m>
            loopedView_S(IM_ContainerAbstractFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_loopedView_S)
            { return _loopedView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         ContainerViewPlus<StoredType, 'a', 'i', FunctorWrap_S<ContainerSize>, ViewPropertiesAlwaysMutable_If_m>
            loopedView_S(const IM_ContainerAbstractFinite<StoredType>& container) noexcept(!config::debuggingEnabledFor_loopedView_S)
            { return _loopedView_S<ContainerSize, ViewPropertiesAlwaysMutable_If_m>(container); }
}

#endif // ED_LOOPED_VIEW_HPP
