// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IS_CONTIGUOUS_RANGE_TPP
#define ED_IS_CONTIGUOUS_RANGE_TPP

#include "willOverflowOnAdd.hpp"
#include "Limits.hpp"
#include "_checkInterface_isContiguousRangeWithin.hpp"

namespace ed
{
   template <FUNDAMENTAL_UINT T>
      constexpr bool isContiguousRange(const T& begin, const T& size) noexcept
      { return (!willOverflowOnAdd(begin, size)) || ((begin + size) == 0); }

   template <FUNDAMENTAL_UINT T>
      constexpr bool isContiguousRangeWithin(const T& begin, const T& size, const T& outerRangeSize) noexcept
      { return ((!willOverflowOnAdd(begin - outerRangeSize - 1, size)) && (begin <= outerRangeSize)) || (size == 0); }

   template <FUNDAMENTAL_UINT T>
      constexpr bool isContiguousRangeWithin_OuterFromEnd(const T& begin, const T& size, const T& outerRangeSize) noexcept
      { return ((begin > (maxOf_V<T> - outerRangeSize)) && (!willOverflowOnAdd(begin, size - 1))) || (size == 0); }

   template <FUNDAMENTAL_UINT T>
      bool isContiguousRangeWithin(const T& begin, const T& size, const T& outerRangeBegin, const T& outerRangeSize) noexcept(!config::debuggingEnabledFor_isContiguousRangeWithin)
      {
         if constexpr (config::debuggingEnabledFor_isContiguousRangeWithin)
            _checkInterface_isContiguousRangeWithin(begin, size, outerRangeBegin, outerRangeSize);

         return ((!willOverflowOnAdd(begin - outerRangeSize - outerRangeBegin - 1, size)) && ((begin - outerRangeBegin) <= outerRangeSize)) || (size == 0);
      }
}

#endif // ED_IS_CONTIGUOUS_RANGE_TPP
