// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IS_CONTIGUOUS_RANGE_HPP
#define ED_IS_CONTIGUOUS_RANGE_HPP

#include "FundamentalIntConcepts.hpp"
#include "edeniumConfig_debugModeSettings.hpp"

namespace ed
{
   template <FUNDAMENTAL_UINT T> constexpr bool isContiguousRange                   (const T& begin, const T& size)                          noexcept;
   template <FUNDAMENTAL_UINT T> constexpr bool isContiguousRangeWithin             (const T& begin, const T& size, const T& outerRangeSize) noexcept;
   template <FUNDAMENTAL_UINT T> constexpr bool isContiguousRangeWithin_OuterFromEnd(const T& begin, const T& size, const T& outerRangeSize) noexcept;

   template <FUNDAMENTAL_UINT T>
      bool isContiguousRangeWithin(const T& begin, const T& size, const T& outerRangeBegin, const T& outerRangeSize) noexcept(!config::debuggingEnabledFor_isContiguousRangeWithin);
}

#include "isContiguousRange.tpp"

#endif // ED_IS_CONTIGUOUS_RANGE_HPP
