// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_EDENIUM_CONFIG_MAIN_HPP
#define ED_EDENIUM_CONFIG_MAIN_HPP

#include "ndebugDefined.hpp"

#include <cstdint>
#include <vector>
#include <string>

namespace ed
{
   namespace config
   {
      static constexpr bool defaultDebugMode = !ndebugDefined_V;

      extern bool          printDebugMessages;
      extern uint_least8_t tabWidthInDebugMessages;

      extern void (*const defaultDebugCallback) (const std::vector<std::string>&);
   }
}

#endif // ED_EDENIUM_CONFIG_MAIN_HPP
