// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_DEBUG_DEFAULT_CALLBACK_HPP
#define ED_DEBUG_DEFAULT_CALLBACK_HPP

#include <vector>
#include <string>

namespace ed
{
   namespace debug
   {
      template <char Action>
         void defaultCallback(const std::vector<std::string>& debugData)
         { static_assert(Action != 'i' && Action != 't' && Action != 'x', "`Action` template argument must be either 'i' (ignore), 't' (throw exception) or 'x' (exit)."); }

         template <> void defaultCallback<'i'>(const std::vector<std::string>& debugData);
         template <> void defaultCallback<'t'>(const std::vector<std::string>& debugData);
         template <> void defaultCallback<'x'>(const std::vector<std::string>& debugData);
   }
}

#endif // ED_DEBUG_DEFAULT_CALLBACK_HPP
