// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "debug_defaultCallback.hpp"

#include "_debug_printMessages.hpp"

#include <stdexcept>
#include <cstdlib>

namespace ed
{
   namespace debug
   {
      template <>
         void defaultCallback<'i'>(const std::vector<std::string>& debugData)
         { _printMessages(debugData); }

      template <>
         void defaultCallback<'t'>(const std::vector<std::string>& debugData)
         {
            _printMessages(debugData);
            throw std::runtime_error("[Edenium] An error occured. One of the library features was used incorrectly.");
         }

      template <>
         void defaultCallback<'x'>(const std::vector<std::string>& debugData)
         {
            _printMessages(debugData);
            std::exit(1);
         }
   }
}
