// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CREATE_CONTAINER_VIEW_PLUS_HPP
#define ED_CREATE_CONTAINER_VIEW_PLUS_HPP

#include "CVP_COMPATIBLE_FUNCTOR.hpp"
#include "meta_ContainerView.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"

#include <cstdint>

namespace ed
{
   /// Variants creating finite view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(      I_ContainerSolid<StoredType>& target,
                                       const StoredFunctorType&            functorToCopy,
                                       const uintmax_t&                    size)
               { return ContainerViewPlus<StoredType, 's', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(const I_ContainerSolid<StoredType>& target,
                                       const StoredFunctorType&            functorToCopy,
                                       const uintmax_t&                    size)
               { return ContainerViewPlus<StoredType, 's', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy, size); }

   /// Variants creating infinite view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(      I_ContainerSolid<StoredType>& target,
                                       const StoredFunctorType&            functorToCopy)
               { return ContainerViewPlus<StoredType, 's', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 's', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(const I_ContainerSolid<StoredType>& target,
                                       const StoredFunctorType&            functorToCopy)
               { return ContainerViewPlus<StoredType, 's', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy); }

   /// Variants creating finite view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(      I_ContainerAbstract<StoredType>& target,
                                       const StoredFunctorType&               functorToCopy,
                                       const uintmax_t&                       size)
               { return ContainerViewPlus<StoredType, 'a', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(const I_ContainerAbstract<StoredType>& target,
                                       const StoredFunctorType&               functorToCopy,
                                       const uintmax_t&                       size)
               { return ContainerViewPlus<StoredType, 'a', 'f', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy, size); }

   /// Variants creating infinite view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(      I_ContainerAbstract<StoredType>& target,
                                       const StoredFunctorType&               functorToCopy)
               { return ContainerViewPlus<StoredType, 'a', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, CVP_COMPATIBLE_FUNCTOR StoredFunctorType>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerViewPlus<StoredType, 'a', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
               createContainerViewPlus(const I_ContainerAbstract<StoredType>& target,
                                       const StoredFunctorType&               functorToCopy)
               { return ContainerViewPlus<StoredType, 'a', 'i', StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>(target, functorToCopy); }
}

#endif // ED_CREATE_CONTAINER_VIEW_PLUS_HPP
