// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CREATE_CONTAINER_VIEW_HPP
#define ED_CREATE_CONTAINER_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "ContainerView.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "I_Functor.hpp"

#include <cstdint>

namespace ed
{
   /// Variants creating finite view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerSolid<StoredType>&                               target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 's', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerSolid<StoredType>&                               target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 's', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerSolid<StoredType>&                               target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 's', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerSolid<StoredType>&                               target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 's', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

   /// Variants creating infinite view of solid container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerSolid<StoredType>&                               target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 's', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerSolid<StoredType>&                               target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 's', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerSolid<StoredType>&                               target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 's', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 's', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerSolid<StoredType>&                               target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 's', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

   /// Variants creating finite view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerAbstract<StoredType>&                            target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 'a', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerAbstract<StoredType>&                            target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 'a', 'f', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerAbstract<StoredType>&                            target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 'a', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerAbstract<StoredType>&                            target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor,
                                   const uintmax_t&                                                  size)           noexcept
               { return ContainerView<StoredType, 'a', 'f', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor, size); }

   /// Variants creating infinite view of abstract container

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerAbstract<StoredType>&                            target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 'a', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerAbstract<StoredType>&                            target,
                                   const I_Functor<'c', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 'a', 'i', 'c', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(      I_ContainerAbstract<StoredType>&                            target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 'a', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }

      template <char ViewPropertiesAlwaysMutable_If_m = ' ', typename StoredType, typename FunctorReturnType, typename... FunctorArgumentTypes>
         requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
            ContainerView<StoredType, 'a', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>
               createContainerView(const I_ContainerAbstract<StoredType>&                            target,
                                         I_Functor<'m', FunctorReturnType, FunctorArgumentTypes...>& mappingFunctor) noexcept
               { return ContainerView<StoredType, 'a', 'i', 'm', ViewPropertiesAlwaysMutable_If_m>(target, mappingFunctor); }
}

#include "createContainerViewPlus.hpp"

#endif // ED_CREATE_CONTAINER_VIEW_HPP
