// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_SUBSAMPLE_VIEW_HPP
#define ED_IMPL_SUBSAMPLE_VIEW_HPP

#include "ContainerConcepts.hpp"
#include "meta_ContainerView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_subsampleView.hpp"
#include "createContainerView.hpp"
#include "FunctorScale.hpp"
#include "subsampledContainerSize.hpp"
#include "IA_ContainerFinite.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _subsampleView(ContainerInterface& container, const uintmax_t& subsamplingFactor) noexcept(CONTAINER_INFINITE<ContainerInterface> ? !config::debuggingEnabledFor_subsampleView : false)
            {
               if constexpr (config::debuggingEnabledFor_subsampleView)
                  _checkInterface_subsampleView(subsamplingFactor);

               if constexpr (CONTAINER_FINITE<ContainerInterface>)
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorScale(subsamplingFactor), subsampledContainerSize(container.size(), subsamplingFactor));
               else
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorScale(subsamplingFactor));
            }

   template <uintmax_t SubsamplingFactor, char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _subsampleView_S(ContainerInterface& container) noexcept(CONTAINER_INFINITE<ContainerInterface>)
            {
               static_assert(SubsamplingFactor != 0, "`SubsamplingFactor` template argument must not be 0.");

               if constexpr (CONTAINER_FINITE<ContainerInterface>)
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorScale_S<SubsamplingFactor>(), subsampledContainerSize(container.size(), SubsamplingFactor));
               else
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorScale_S<SubsamplingFactor>());
            }
}

#endif // ED_IMPL_SUBSAMPLE_VIEW_HPP
