// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_REVERSE_VIEW_HPP
#define ED_IMPL_REVERSE_VIEW_HPP

#include "ContainerConcepts.hpp"
#include "meta_ContainerView.hpp"
#include "createContainerView.hpp"
#include "FunctorReverse.hpp"
#include "IA_ContainerFinite.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_reverseView.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE_FINITE_ANY ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _reverseView(ContainerInterface& container)
            { return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorReverse(container.size() - 1), container.size()); }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE_FINITE_ANY ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _reverseView_S(ContainerInterface& container) noexcept(!config::debuggingEnabledFor_reverseView_S)
            {
               if constexpr (config::debuggingEnabledFor_reverseView_S)
                  _checkInterface_reverseView(ContainerSize, container.size());

               return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorReverse_S<ContainerSize - 1>(), ContainerSize);
            }
}

#endif // ED_IMPL_REVERSE_VIEW_HPP
