// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_PART_VIEW_N_HPP
#define ED_IMPL_PART_VIEW_N_HPP

#include "ContainerConcepts.hpp"
#include "meta_ContainerView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_partViewN.hpp"
#include "IA_ContainerFinite.hpp"
#include "createContainerView.hpp"
#include "FunctorOffset.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partViewN(ContainerInterface& container, const uintmax_t& elemCount, const uintmax_t& firstIndex) noexcept(!config::debuggingEnabledFor_partViewN)
            {
               if constexpr (config::debuggingEnabledFor_partViewN)
               {
                  if constexpr (CONTAINER_FINITE<ContainerInterface>)
                     _checkInterface_partViewN<false>(firstIndex, elemCount, container.size());
                  else
                     _checkInterface_partViewN<false>(firstIndex, elemCount);
               }

               return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorOffset(firstIndex), elemCount);
            }

   template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partViewN_S(ContainerInterface& container, const uintmax_t& elemCount) noexcept(!config::debuggingEnabledFor_partViewN_S)
            {
               if constexpr (config::debuggingEnabledFor_partViewN_S)
               {
                  if constexpr (CONTAINER_FINITE<ContainerInterface>)
                     _checkInterface_partViewN<true>(FirstIndex, elemCount, container.size());
                  else
                     _checkInterface_partViewN<true>(FirstIndex, elemCount);
               }

               return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorOffset_S<FirstIndex>(), elemCount);
            }
}

#endif // ED_IMPL_PART_VIEW_N_HPP
