// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_PART_VIEW_HPP
#define ED_IMPL_PART_VIEW_HPP

#include "ContainerConcepts.hpp"
#include "meta_ContainerView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_partView.hpp"
#include "IA_ContainerFinite.hpp"
#include "_partViewN.hpp"
#include "ContainerUtils.hpp"
#include "createContainerView.hpp"
#include "FunctorOffset.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partView(ContainerInterface& container, const uintmax_t& firstIndex, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView)
            {
               if constexpr (config::debuggingEnabledFor_partView)
               {
                  if constexpr (CONTAINER_FINITE<ContainerInterface>)
                     _checkInterface_partView<false>(firstIndex, lastIndex, container.size());
                  else
                     _checkInterface_partView<false>(firstIndex, lastIndex);
               }

               return _partViewN<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndex - firstIndex + 1);
            }

   template <char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partView(ContainerInterface& container, const uintmax_t& firstIndex) noexcept(CONTAINER_INFINITE<ContainerInterface>)
            {
               if constexpr (CONTAINER_FINITE<ContainerInterface>)
               {
                  if constexpr (config::debuggingEnabledFor_partView)
                     _checkInterface_partView_noLastIndex<false>(firstIndex, container.size());

                  return _partView<ViewPropertiesAlwaysMutable_If_m>(container, firstIndex, lastIndexOf(container));
               }
               else
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorOffset(firstIndex));
            }

   template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partView_S(ContainerInterface& container, const uintmax_t& lastIndex) noexcept(!config::debuggingEnabledFor_partView_S)
            {
               if constexpr (config::debuggingEnabledFor_partView_S)
               {
                  if constexpr (CONTAINER_FINITE<ContainerInterface>)
                     _checkInterface_partView<true>(FirstIndex, lastIndex, container.size());
                  else
                     _checkInterface_partView<true>(FirstIndex, lastIndex);
               }

               return _partViewN_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndex - FirstIndex + 1);
            }

   template <uintmax_t FirstIndex, char ViewPropertiesAlwaysMutable_If_m = ' ', CONTAINER_INTERFACE ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _partView_S(ContainerInterface& container) noexcept(CONTAINER_INFINITE<ContainerInterface>)
            {
               if constexpr (CONTAINER_FINITE<ContainerInterface>)
               {
                  if constexpr (config::debuggingEnabledFor_partView_S)
                     _checkInterface_partView_noLastIndex<true>(FirstIndex, container.size());

                  return _partView_S<FirstIndex, ViewPropertiesAlwaysMutable_If_m>(container, lastIndexOf(container));
               }
               else
                  return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorOffset_S<FirstIndex>());
            }
}

#endif // ED_IMPL_PART_VIEW_HPP
