// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_LOOPED_VIEW_HPP
#define ED_IMPL_LOOPED_VIEW_HPP

#include "ContainerConcepts.hpp"
#include "meta_ContainerView.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_loopedView.hpp"
#include "IA_ContainerFinite.hpp"
#include "createContainerView.hpp"
#include "FunctorWrap.hpp"

#include <cstdint>

namespace ed
{
   template <char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE_FINITE_ANY ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _loopedView(ContainerInterface& container)
            {
               if constexpr (config::debuggingEnabledFor_loopedView)
                  _checkInterface_loopedView(container.size());

               return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorWrap(container.size()));
            }

   template <uintmax_t ContainerSize, char ViewPropertiesAlwaysMutable_If_m, CONTAINER_INTERFACE_FINITE_ANY ContainerInterface>
      requires(meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
         auto
            _loopedView_S(ContainerInterface& container) noexcept(!config::debuggingEnabledFor_loopedView_S)
            {
               static_assert(ContainerSize != 0, "`ContainerSize` template argument must not be 0.");
               if constexpr (config::debuggingEnabledFor_loopedView_S)
                  _checkInterface_loopedView_S(ContainerSize, container.size());

               return createContainerViewPlus<ViewPropertiesAlwaysMutable_If_m>(container, FunctorWrap_S<ContainerSize>());
            }
}

#endif // ED_IMPL_LOOPED_VIEW_HPP
