// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_IS_INTERFACE_FUNCTOR_V_HPP
#define ED_IMPL_IS_INTERFACE_FUNCTOR_V_HPP

#include "I_Functor.hpp"

namespace ed
{
   template <typename T>                                     static constexpr bool _isInterface_FunctorWithConstCallOp_V                                                     = false;
   template <typename ReturnType, typename... ArgumentTypes> static constexpr bool _isInterface_FunctorWithConstCallOp_V<      I_Functor<'c', ReturnType, ArgumentTypes...>> = true;
   template <typename ReturnType, typename... ArgumentTypes> static constexpr bool _isInterface_FunctorWithConstCallOp_V<const I_Functor<'c', ReturnType, ArgumentTypes...>> = true;

   template <typename T>                                     static constexpr bool _isInterface_FunctorWithMutatingCallOp_V                                               = false;
   template <typename ReturnType, typename... ArgumentTypes> static constexpr bool _isInterface_FunctorWithMutatingCallOp_V<I_Functor<'m', ReturnType, ArgumentTypes...>> = true;
}

#endif // ED_IMPL_IS_INTERFACE_FUNCTOR_V_HPP
