// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_IS_INTERFACE_CONTAINER_V_HPP
#define ED_IMPL_IS_INTERFACE_CONTAINER_V_HPP

#include "I_Container.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"

namespace ed
{
   template <typename T>          static constexpr bool _isInterface_ContainerSolid_V                                     = false;
   template <typename StoredType> static constexpr bool _isInterface_ContainerSolid_V<      I_ContainerSolid<StoredType>> = true;
   template <typename StoredType> static constexpr bool _isInterface_ContainerSolid_V<const I_ContainerSolid<StoredType>> = true;

   template <typename T>          static constexpr bool _isInterface_ContainerAbstract_V                                        = false;
   template <typename StoredType> static constexpr bool _isInterface_ContainerAbstract_V<      I_ContainerAbstract<StoredType>> = true;
   template <typename StoredType> static constexpr bool _isInterface_ContainerAbstract_V<const I_ContainerAbstract<StoredType>> = true;

   template <typename T>          static constexpr bool _isInterface_ContainerSolidFinite_V                                            = false;
   template <typename StoredType> static constexpr bool _isInterface_ContainerSolidFinite_V<      IM_ContainerSolidFinite<StoredType>> = true;
   template <typename StoredType> static constexpr bool _isInterface_ContainerSolidFinite_V<const IM_ContainerSolidFinite<StoredType>> = true;

   template <typename T>          static constexpr bool _isInterface_ContainerAbstractFinite_V                                               = false;
   template <typename StoredType> static constexpr bool _isInterface_ContainerAbstractFinite_V<      IM_ContainerAbstractFinite<StoredType>> = true;
   template <typename StoredType> static constexpr bool _isInterface_ContainerAbstractFinite_V<const IM_ContainerAbstractFinite<StoredType>> = true;
}

#endif // ED_IMPL_IS_INTERFACE_CONTAINER_V_HPP
