// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_DEBUG_PRINT_MESSAGES_HPP
#define ED_IMPL_DEBUG_PRINT_MESSAGES_HPP

#include "edeniumConfig_main.hpp"

#include <vector>
#include <string>
#include <iostream>

namespace ed
{
   namespace debug
   {
      void _printMessages(const std::vector<std::string>& debugMessages)
      {
         if(config::printDebugMessages)
         {
            std::cout << std::endl;
            for(auto& i: debugMessages)
               std::cout << i << std::endl;
         }
      }
   }
}

#endif // ED_IMPL_DEBUG_PRINT_MESSAGES_HPP
