// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "_debug_generateErrorString.hpp"

#include "edeniumConfig_main.hpp"

namespace ed
{
   namespace debug
   {
      std::string _n_spaces(const uint_least16_t& numberOfSpaces)
      { return std::string(numberOfSpaces, ' '); }

      std::string _generateErrorString(const std::string& whereErrorHappened, const std::string& errorDescription, const std::string& extraMessage)
      {
         const auto& tabWidth = config::tabWidthInDebugMessages;

         return std::string("[Edenium][ERROR: Contract violation]\n")
                + _n_spaces(tabWidth    ) + "[" + whereErrorHappened + "]\n"
                + _n_spaces(tabWidth * 2) + errorDescription
                + ((extraMessage != "") ? ("\n" + _n_spaces(tabWidth * 2) + extraMessage) : "");
      }
   }
}
