// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_SUBSAMPLED_CONTAINER_SIZE_HPP
#define ED_IMPL_CHECK_INTERFACE_SUBSAMPLED_CONTAINER_SIZE_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_debug_generateErrorString.hpp"

#include <cstdint>
#include <vector>
#include <string>

namespace ed
{
   inline void _checkInterface_subsampledContainerSize(const uintmax_t& containerSize, const uintmax_t& subsamplingFactor)
   {
      if(subsamplingFactor == 0)
         config::debugCallback_subsampledContainerSize(std::vector<std::string>{debug::_generateErrorString("ed::subsampledContainerSize()",
                                                                                                            "`subsamplingFactor` must not be 0.",
                                                                                                            std::string("Got: `containerSize` = ") + std::to_string(containerSize))});
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_SUBSAMPLED_CONTAINER_SIZE_HPP
