// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_REVERSE_VIEW_HPP
#define ED_IMPL_CHECK_INTERFACE_REVERSE_VIEW_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_unequalContainerSizes.hpp"

#include <cstdint>

namespace ed
{
   inline void _checkInterface_reverseView(const uintmax_t& passedContainerSize, const uintmax_t& actualContainerSize)
   {
      if(passedContainerSize != actualContainerSize)
         config::debugCallback_reverseView_S(_checkInterfaceHelper_unequalContainerSizes("ed::reverseView_S()", passedContainerSize, actualContainerSize));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_REVERSE_VIEW_HPP
