// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_PART_VIEW_N_HPP
#define ED_IMPL_CHECK_INTERFACE_PART_VIEW_N_HPP

#include "isContiguousRange.hpp"
#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_partViewN.hpp"

#include <cstdint>

namespace ed
{
   template <bool StaticVariant>
      inline void _checkInterface_partViewN(const uintmax_t& firstIndex, const uintmax_t& elemCount)
      {
         if(!isContiguousRange(firstIndex, elemCount))
         {
            if constexpr (StaticVariant)
               config::debugCallback_partViewN_S_overflowingRange(_checkInterfaceHelper_partViewN_overflowingRange<StaticVariant>(firstIndex, elemCount));
            else
               config::debugCallback_partViewN_overflowingRange(_checkInterfaceHelper_partViewN_overflowingRange<StaticVariant>(firstIndex, elemCount));
         }
      }

   template <bool StaticVariant>
      inline void _checkInterface_partViewN(const uintmax_t& firstIndex, const uintmax_t& elemCount, const uintmax_t& containerSize)
      {
         if(!isContiguousRangeWithin(firstIndex, elemCount, containerSize))
         {
            if constexpr (StaticVariant)
               config::debugCallback_partViewN_S_invalidRange(_checkInterfaceHelper_partViewN_invalidRange<StaticVariant>(firstIndex, elemCount, containerSize));
            else
               config::debugCallback_partViewN_invalidRange(_checkInterfaceHelper_partViewN_invalidRange<StaticVariant>(firstIndex, elemCount, containerSize));
         }
      }
}

#endif // ED_IMPL_CHECK_INTERFACE_PART_VIEW_N_HPP
