// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_PART_VIEW_HPP
#define ED_IMPL_CHECK_INTERFACE_PART_VIEW_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_partView.hpp"

#include <cstdint>

namespace ed
{
   template <bool StaticVariant>
      inline void _checkInterface_partView(const uintmax_t& firstIndex, const uintmax_t& lastIndex)
      {
         if(firstIndex > lastIndex)
         {
            if constexpr (StaticVariant)
               config::debugCallback_partView_S_wrongIndexOrder(_checkInterfaceHelper_partView_wrongIndexOrder<StaticVariant>(firstIndex, lastIndex));
            else
               config::debugCallback_partView_wrongIndexOrder(_checkInterfaceHelper_partView_wrongIndexOrder<StaticVariant>(firstIndex, lastIndex));
         }
      }

   template <bool StaticVariant>
      inline void _checkInterface_partView(const uintmax_t& firstIndex, const uintmax_t& lastIndex, const uintmax_t& containerSize)
      {
         _checkInterface_partView<StaticVariant>(firstIndex, lastIndex);

         if(lastIndex >= containerSize)
         {
            if constexpr (StaticVariant)
               config::debugCallback_partView_S_lastIndexTooBig(_checkInterfaceHelper_partView_lastIndexTooBig<StaticVariant>(lastIndex, containerSize));
            else
               config::debugCallback_partView_lastIndexTooBig(_checkInterfaceHelper_partView_lastIndexTooBig<StaticVariant>(lastIndex, containerSize));
         }
      }

   template <bool StaticVariant>
      inline void _checkInterface_partView_noLastIndex(const uintmax_t& firstIndex, const uintmax_t& containerSize)
      {
         if(firstIndex >= containerSize)
         {
            if constexpr (StaticVariant)
               config::debugCallback_partView_S_firstIndexTooBig(_checkInterfaceHelper_partView_firstIndexTooBig<StaticVariant>(firstIndex, containerSize));
            else
               config::debugCallback_partView_firstIndexTooBig(_checkInterfaceHelper_partView_firstIndexTooBig<StaticVariant>(firstIndex, containerSize));
         }
      }
}

#endif // ED_IMPL_CHECK_INTERFACE_PART_VIEW_HPP
