// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_LOOPED_VIEW_HPP
#define ED_IMPL_CHECK_INTERFACE_LOOPED_VIEW_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_emptyContainer.hpp"
#include "_checkInterfaceHelper_unequalContainerSizes.hpp"

#include <cstdint>

namespace ed
{
   inline void _checkInterface_loopedView(const uintmax_t& containerSize)
   {
      if(containerSize == 0)
         config::debugCallback_loopedView(_checkInterfaceHelper_emptyContainer("ed::loopedView()"));
   }

   inline void _checkInterface_loopedView_S(const uintmax_t& passedContainerSize, const uintmax_t& actualContainerSize)
   {
      if(passedContainerSize == 0)
         config::debugCallback_loopedView_S_emptyContainer(_checkInterfaceHelper_emptyContainer("ed::loopedView_S()"));
      if(passedContainerSize != actualContainerSize)
         config::debugCallback_loopedView_S_unequalSizes(_checkInterfaceHelper_unequalContainerSizes("ed::loopedView_S()", passedContainerSize, actualContainerSize));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_LOOPED_VIEW_HPP
