// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_IS_CONTIGUOUS_RANGE_WITHIN_HPP
#define ED_IMPL_CHECK_INTERFACE_IS_CONTIGUOUS_RANGE_WITHIN_HPP

#include "FundamentalIntConcepts.hpp"
#include "isContiguousRange.hpp"
#include "edeniumConfig_debugCallbacks.hpp"
#include "_debug_generateErrorString.hpp"
#include "Limits.hpp"

#include <vector>
#include <string>

namespace ed
{
   template <FUNDAMENTAL_UINT T>
   inline void _checkInterface_isContiguousRangeWithin(const T& begin, const T& size, const T& outerRangeBegin, const T& outerRangeSize)
   {
      if(!isContiguousRange(outerRangeBegin, outerRangeSize))
         config::debugCallback_isContiguousRangeWithin(std::vector<std::string>{debug::_generateErrorString("ed::isContiguousRangeWithin()",
                                                                                                            "`outerRangeBegin - 1 + outerRangeSize` must not overflow.",
                                                                                                            std::string("Got: `begin` = ")               + std::to_string(begin)
                                                                                                                         + ", `size` = "                 + std::to_string(size)
                                                                                                                         + ", `outerRangeBegin` = "      + std::to_string(outerRangeBegin)
                                                                                                                         + ", `outerRangeSize` = "       + std::to_string(outerRangeSize)
                                                                                                                         + ", highest possible index = " + std::to_string(maxOf_V<T>))});
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_IS_CONTIGUOUS_RANGE_WITHIN_HPP
