// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_ALLOC_HPP
#define ED_IMPL_CHECK_INTERFACE_ALLOC_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_debug_generateErrorString.hpp"

#include <cstdint>
#include <vector>
#include <string>

namespace ed
{
   inline void _checkInterface_alloc(const uintmax_t& byteCount)
   {
      if(byteCount == 0)
         config::debugCallback_alloc(std::vector<std::string>{debug::_generateErrorString("ed::alloc()", "`byteCount` must not be 0.")});
   }

   inline void _checkInterface_allocT(const uintmax_t& objectCount)
   {
      if(objectCount == 0)
         config::debugCallback_allocT(std::vector<std::string>{debug::_generateErrorString("ed::allocT()", "`objectCount` must not be 0.")});
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_ALLOC_HPP
