// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_FUNCTOR_WRAP_HPP
#define ED_IMPL_CHECK_INTERFACE_FUNCTOR_WRAP_HPP

#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_modulusZero.hpp"

#include <cstdint>

namespace ed
{
   inline void _checkInterface_FunctorWrap_ctor(const uintmax_t& modulus)
   {
      if(modulus == 0)
         config::debugCallback_FunctorWrap_ctor(_checkInterfaceHelper_modulusZero("ed::FunctorWrap::FunctorWrap()"));
   }

   inline void _checkInterface_FunctorWrap_setModulus(const uintmax_t& modulus)
   {
      if(modulus == 0)
         config::debugCallback_FunctorWrap_setModulus(_checkInterfaceHelper_modulusZero("ed::FunctorWrap::setModulus()"));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_FUNCTOR_WRAP_HPP
