// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_CONTAINER_VIEW_HPP
#define ED_IMPL_CHECK_INTERFACE_CONTAINER_VIEW_HPP

#include "TypeVariationsConcepts.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "_checkInterfaceHelper_repointing.hpp"
#include "edeniumConfig_debugCallbacks.hpp"
#include "_debug_generateErrorString.hpp"
#include "_checkInterfaceHelper_indexOutOfRange.hpp"

#include <cstdint>
#include <vector>
#include <string>

namespace ed
{
   template <typename StoredType, POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
   inline void _checkInterface_ContainerView_repoint(const AdequatePtrType&                     pointer,
                                                     const uintmax_t&                           currentIndex,
                                                     const uintmax_t&                           targetIndex,
                                                     const IM_ContainerSolidFinite<StoredType>& view)
   { _checkInterfaceHelper_repointing(pointer, currentIndex, targetIndex, view, "ed::ContainerView::repoint()", "view", config::debugCallback_ContainerView_repoint); }

   inline void _checkInterface_ContainerView_target(const bool& isTargetConst)
   {
      if(isTargetConst)
         config::debugCallback_ContainerView_target(std::vector<std::string>{debug::_generateErrorString("ed::ContainerView::target()",
                                                                                                         "Tried to get a non-const access to a const container. "
                                                                                                            "This non-const view is bound a to a const container.")});
   }

   inline void _checkInterface_ContainerView_set(const uintmax_t& index, const uintmax_t& viewSize)
   {
      if(index >= viewSize)
         config::debugCallback_ContainerView_set(_checkInterfaceHelper_indexOutOfRange("ed::ContainerView::set()", "view", index, viewSize));
   }

   inline void _checkInterface_ContainerView_op_call(const uintmax_t& index, const uintmax_t& viewSize)
   {
      if(index >= viewSize)
         config::debugCallback_ContainerView_op_call(_checkInterfaceHelper_indexOutOfRange("ed::ContainerView::operator()", "view", index, viewSize));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_CONTAINER_VIEW_HPP
