// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_ARRAY_HPP
#define ED_IMPL_CHECK_INTERFACE_ARRAY_HPP

#include "TypeVariationsConcepts.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "_checkInterfaceHelper_repointing.hpp"
#include "edeniumConfig_debugCallbacks.hpp"
#include "_checkInterfaceHelper_indexOutOfRange.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType, POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
      inline void _checkInterface_Array_repoint(const AdequatePtrType&                     pointer,
                                                const uintmax_t&                           currentIndex,
                                                const uintmax_t&                           targetIndex,
                                                const IM_ContainerSolidFinite<StoredType>& array)
      { _checkInterfaceHelper_repointing(pointer, currentIndex, targetIndex, array, "ed::Array::repoint()", "Array", config::debugCallback_Array_repoint); }

   inline void _checkInterface_Array_op_call(const uintmax_t& index, const uintmax_t& arraySize)
   {
      if(index >= arraySize)
         config::debugCallback_Array_op_call(_checkInterfaceHelper_indexOutOfRange("ed::Array::operator()", "Array", index, arraySize));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_ARRAY_HPP
