// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_HELPER_UNEQUAL_CONTAINER_SIZES_HPP
#define ED_IMPL_CHECK_INTERFACE_HELPER_UNEQUAL_CONTAINER_SIZES_HPP

#include "_debug_generateErrorString.hpp"

#include <string>
#include <cstdint>
#include <vector>

namespace ed
{
   inline auto _checkInterfaceHelper_unequalContainerSizes(const std::string& whereErrorHappened, const uintmax_t& passedContainerSize, const uintmax_t& actualContainerSize)
   { return std::vector<std::string>{debug::_generateErrorString(whereErrorHappened,
                                                                 "`ContainerSize` template argument must be equal to `container.size()`.",
                                                                 std::string("Got: `ContainerSize` = ")   + std::to_string(passedContainerSize)
                                                                              + ", `container.size()` = " + std::to_string(actualContainerSize))}; }
}

#endif // ED_IMPL_CHECK_INTERFACE_HELPER_UNEQUAL_CONTAINER_SIZES_HPP
