#ifndef ED_IMPL_CHECK_INTERFACE_HELPER_REPOINTING_HPP
#define ED_IMPL_CHECK_INTERFACE_HELPER_REPOINTING_HPP

// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "_debug_generateErrorString.hpp"
#include "TypeVariationsConcepts.hpp"
#include "IM_ContainerSolidFinite.hpp"

#include <string>
#include <cstdint>
#include <vector>

namespace ed
{
   inline auto _checkInterfaceHelper_repointing_genErrorStr(const std::string& whereErrorHappened,
                                                            const bool&        isCurrentIndexWrong,
                                                            const std::string& whatKindOfContainer,
                                                            const uintmax_t&   currentIndex,
                                                            const uintmax_t&   targetIndex,
                                                            const uintmax_t&   containerSize)
   {
      return std::vector<std::string>{debug::_generateErrorString(whereErrorHappened,
                                                                  std::string(isCurrentIndexWrong ? "`currentIndex`" : "`targetIndex`")
                                                                     + " must be smaller than the size of this " + whatKindOfContainer + ".",
                                                                  std::string("Got: `currentIndex` = ") + std::to_string(currentIndex)
                                                                               + ", `targetIndex` = "   + std::to_string(targetIndex)
                                                                               + ", `size()` = "        + std::to_string(containerSize))};
   }

   template <typename StoredType, POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
   inline void _checkInterfaceHelper_repointing(const AdequatePtrType&                     pointer,
                                                const uintmax_t&                           currentIndex,
                                                const uintmax_t&                           targetIndex,
                                                const IM_ContainerSolidFinite<StoredType>& container,
                                                const std::string&                         whereErrorHappened,
                                                const std::string&                         whatKindOfContainer,
                                                void (*const &callback) (const std::vector<std::string>&))
   {
      const uintmax_t containerSize = container.size();

      if(currentIndex >= containerSize)
         callback(_checkInterfaceHelper_repointing_genErrorStr(whereErrorHappened, true, whatKindOfContainer, currentIndex, targetIndex, containerSize));
      else
      {
         const StoredType* const expectedAddress = &container(currentIndex);
         if(pointer != expectedAddress)
            callback(std::vector<std::string>{debug::_generateErrorString(whereErrorHappened,
                                                                          std::string("`pointer` must point to this ") + whatKindOfContainer + "'s element at `currentIndex`.",
                                                                          std::string("Got: `pointer` raw value: ")    + std::to_string(reinterpret_cast<uintptr_t>(pointer))
                                                                                       + ", expected value: "          + std::to_string(reinterpret_cast<uintptr_t>(expectedAddress)))});
      }
      if(targetIndex >= containerSize)
         callback(_checkInterfaceHelper_repointing_genErrorStr(whereErrorHappened, false, whatKindOfContainer, currentIndex, targetIndex, containerSize));
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_HELPER_REPOINTING_HPP
