// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_N_HPP
#define ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_N_HPP

#include "_debug_generateErrorString.hpp"
#include "_checkInterfaceHelper_partView_base.hpp"
#include "Limits.hpp"

#include <string>
#include <cstdint>
#include <vector>

namespace ed
{
   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partViewN__name()
      { return std::string(StaticVariant ? "ed::partViewN_S()" : "ed::partViewN()"); }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partViewN__firstIndexBeginStr()
      { return std::string(StaticVariant ? "`FirstIndex" : "`firstIndex"); }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partViewN_overflowingRange(const uintmax_t& firstIndex, const uintmax_t& elemCount)
      {
         return std::vector<std::string>{debug::_generateErrorString(_checkInterfaceHelper_partViewN__name              <StaticVariant>(),
                                                                     _checkInterfaceHelper_partViewN__firstIndexBeginStr<StaticVariant>() + " + elemCount - 1` must not overflow.",
                                                                     _checkInterfaceHelper_partView__gotFirstIndexStr   <StaticVariant>() + std::to_string(firstIndex)
                                                                                                          + ", `elemCount` = "            + std::to_string(elemCount)
                                                                                                          + ", highest possible index = " + std::to_string(maxOf_V<uintmax_t>))};
      }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partViewN_invalidRange(const uintmax_t& firstIndex, const uintmax_t& elemCount, const uintmax_t& containerSize)
      {
         return std::vector<std::string>{debug::_generateErrorString(_checkInterfaceHelper_partViewN__name              <StaticVariant>(),
                                                                     _checkInterfaceHelper_partViewN__firstIndexBeginStr<StaticVariant>()
                                                                        + " + elemCount - 1` must be smaller than `container.size()`.",
                                                                     _checkInterfaceHelper_partView__gotFirstIndexStr   <StaticVariant>() + std::to_string(firstIndex)
                                                                                                              + ", `elemCount` = "        + std::to_string(elemCount)
                                                                                                              + ", `container.size()` = " + std::to_string(containerSize))};
      }
}

#endif // ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_N_HPP
