// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_HPP
#define ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_HPP

#include "_debug_generateErrorString.hpp"
#include "_checkInterfaceHelper_partView_base.hpp"

#include <string>
#include <cstdint>
#include <vector>

namespace ed
{
   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partView__name()
      { return std::string(StaticVariant ? "ed::partView_S()" : "ed::partView()"); }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partView__firstIndexFullStr()
      { return std::string(StaticVariant ? "`FirstIndex` template argument" : "`firstIndex`"); }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partView_wrongIndexOrder(const uintmax_t& firstIndex, const uintmax_t& lastIndex)
      {
         return std::vector<std::string>{debug::_generateErrorString(_checkInterfaceHelper_partView__name             <StaticVariant>(),
                                                                     _checkInterfaceHelper_partView__firstIndexFullStr<StaticVariant>() + " must be smaller than or equal to `lastIndex`.",
                                                                     _checkInterfaceHelper_partView__gotFirstIndexStr <StaticVariant>() + std::to_string(firstIndex)
                                                                                                                 + ", `lastIndex` = "   + std::to_string(lastIndex))};
      }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partView_lastIndexTooBig(const uintmax_t& lastIndex, const uintmax_t& containerSize)
      {
         return std::vector<std::string>{debug::_generateErrorString(_checkInterfaceHelper_partView__name<StaticVariant>(),
                                                                     "`lastIndex` must be smaller than `container.size()`.",
                                                                     std::string("Got: `lastIndex` = ")       + std::to_string(lastIndex)
                                                                                  + ", `container.size()` = " + std::to_string(containerSize))};
      }

   template <bool StaticVariant>
      inline auto _checkInterfaceHelper_partView_firstIndexTooBig(const uintmax_t& firstIndex, const uintmax_t& containerSize)
      {
         return std::vector<std::string>{debug::_generateErrorString(_checkInterfaceHelper_partView__name             <StaticVariant>(),
                                                                     _checkInterfaceHelper_partView__firstIndexFullStr<StaticVariant>() + " must be smaller than `container.size()`.",
                                                                     _checkInterfaceHelper_partView__gotFirstIndexStr <StaticVariant>() + std::to_string(firstIndex)
                                                                                                            + ", `container.size()` = " + std::to_string(containerSize))};
      }
}

#endif // ED_IMPL_CHECK_INTERFACE_HELPER_PART_VIEW_HPP
