// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_IMPL_CHECK_INTERFACE_HELPER_INDEX_OUT_OF_RANGE_HPP
#define ED_IMPL_CHECK_INTERFACE_HELPER_INDEX_OUT_OF_RANGE_HPP

#include "_debug_generateErrorString.hpp"

#include <string>
#include <cstdint>
#include <vector>

namespace ed
{
   inline auto _checkInterfaceHelper_indexOutOfRange(const std::string& whereErrorHappened,
                                                     const std::string& whatKindOfContainer,
                                                     const uintmax_t&   index,
                                                     const uintmax_t&   containerSize)
   {
      return std::vector<std::string>{debug::_generateErrorString(whereErrorHappened,
                                                                  std::string("`index` must be smaller than the size of this ") + whatKindOfContainer + ".",
                                                                  std::string("Got: `index` = ") + std::to_string(index)
                                                                               + ", `size()` = " + std::to_string(containerSize))};
   }
}

#endif // ED_IMPL_CHECK_INTERFACE_HELPER_INDEX_OUT_OF_RANGE_HPP
