// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_TYPE_VARIATIONS_CONCEPTS_HPP
#define ED_TYPE_VARIATIONS_CONCEPTS_HPP

#include "ANY_OF.hpp"

namespace ed
{
   template <typename T, typename PureType> concept CONST_AGNOSTIC            = ANY_OF<T, PureType,  const PureType>;
   template <typename T, typename PureType> concept POINTER_TO_CONST_AGNOSTIC = ANY_OF<T, PureType*, const PureType*>;

   template <typename T, typename PureType> concept REFERENCE_AGNOSTIC_L = ANY_OF<T, PureType, PureType&>;
   template <typename T, typename PureType> concept REFERENCE_AGNOSTIC_R = ANY_OF<T, PureType, PureType&&>;
   template <typename T, typename PureType> concept REFERENCE_AGNOSTIC_X = REFERENCE_AGNOSTIC_L<PureType, T> || REFERENCE_AGNOSTIC_R<PureType, T>;
}

#endif // ED_TYPE_VARIATIONS_CONCEPTS_HPP
