// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_SIZEOF_ADDITIONS_HPP
#define ED_SIZEOF_ADDITIONS_HPP

#include <cstdint>
#include <climits>
#include <type_traits>

namespace ed
{
   template <typename T> static constexpr uintmax_t sizeofInBits_V      = sizeof(T) * CHAR_BIT;
   template <typename T> static constexpr uintmax_t smartSizeof_V       = std::is_empty_v<T> ? 0 : sizeof(T);
   template <typename T> static constexpr uintmax_t smartSizeofInBits_V = std::is_empty_v<T> ? 0 : sizeofInBits_V<T>;

   template <typename T> constexpr uintmax_t sizeofInBits     (const T& arg) noexcept { return sizeofInBits_V     <T>; }
   template <typename T> constexpr uintmax_t smartSizeof      (const T& arg) noexcept { return smartSizeof_V      <T>; }
   template <typename T> constexpr uintmax_t smartSizeofInBits(const T& arg) noexcept { return smartSizeofInBits_V<T>; }
}

#endif // ED_SIZEOF_ADDITIONS_HPP
