// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_MEMORY_HPP
#define ED_MEMORY_HPP

#include "NON_VOID.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_alloc.hpp"

#include <cstdint>
#include <new>

namespace ed
{
   template <NON_VOID T>
      T* allocT(const uintmax_t& objectCount)
      {
         if constexpr (config::debuggingEnabledFor_allocT)
            _checkInterface_allocT(objectCount);

         return static_cast<T*>(operator new(sizeof(T) * objectCount));
      }

   void* alloc  (const uintmax_t& byteCount);
   void  dealloc(      void*      pointer)    noexcept;
}

#endif // ED_MEMORY_HPP
