// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "Memory.hpp"

namespace ed
{
   void* alloc(const uintmax_t& byteCount)
   {
      if constexpr (config::debuggingEnabledFor_alloc)
         _checkInterface_alloc(byteCount);

      return static_cast<void*>(allocT<char>(byteCount));
   }

   void dealloc(void* pointer) noexcept
   { operator delete(pointer); }
}
