// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_LIMITS_HPP
#define ED_LIMITS_HPP

#include "FundamentalIntConcepts.hpp"

#include <limits>

namespace ed
{
   template <FUNDAMENTAL_INT T> static constexpr T minOf_V = std::numeric_limits<T>::min();
   template <FUNDAMENTAL_INT T> static constexpr T maxOf_V = std::numeric_limits<T>::max();

   template <FUNDAMENTAL_INT T> constexpr T minOf(const T& x) noexcept { return minOf_V<T>; }
   template <FUNDAMENTAL_INT T> constexpr T maxOf(const T& x) noexcept { return maxOf_V<T>; }
}

#endif // ED_LIMITS_HPP
